const baseOpts = {
    qrCodeBaseUrl: "https://map.abuzzsolutions.asia/amap/embedex3.php?site=VIVOCITY&lazyld=true&mobile=true",
    siteBaseUrl: "/",
    mediaBaseUrl: "/cache",
    labelFontUrl: "assets/fonts/Montserrat_Regular.json",
    amapBaseUrl: "/app/amap/",

    kiosks: {
		
		"Demo-Vivo": { startNodeId: "_27174_23371_1200", camera: [31040, 76296, 64082], scene: [31354, 26673, 1803] },
	

        "VVC-WF001-B201": { startNodeId: "_22573_33483_0", camera: [-19794, -1543, 34342], scene: [26081, 23624, 1803] },
        "VVC-WF002-B202": { startNodeId: "_38283_34759_0", camera: [-18339, 61587, 30109], scene: [29023, 27491, 1803] },
        "VVC-WF003-B101": { startNodeId: "_15418_32104_600", camera: [80262, 26167, 40399], scene: [36254, 26551, 1803] },
        "VVC-WF004-B102": { startNodeId: "_25407_33647_600", camera: [-4886, 63416, 33363], scene: [29438, 28027, 1803] },
        "VVC-WF005-B103": { startNodeId: "_25150_33407_600", camera: [-4886, 63416, 33363], scene: [29438, 28027, 1803] },
        "VVC-WF006-L101": { startNodeId: "_15156_33211_1200", camera: [-32832, 25550, 41572], scene: [22663, 25428, 1803] },
        "VVC-WF007-L102": { startNodeId: "_16160_17789_1200", camera: [-29158, 25699, 44770], scene: [23901, 25583, 1803] },
        "VVC-WF008-L103": { startNodeId: "_16574_13706_1200", camera: [30268, 80935, 60981], scene: [31198, 27660, 1803] },
        "VVC-WF009-L104": { startNodeId: "_25643_36387_1200", camera: [32301, -26214, 66227], scene: [32710, 20590, 1803] },
        "VVC-WF010-L105": { startNodeId: "_27174_34786_1200", camera: [-23738, 25999, 50708], scene: [23901, 25583, 1803] },
        "VVC-WF011-L106": { startNodeId: "_27174_22675_1200", camera: [31001, 83170, 59206], scene: [31603, 27982, 1803] },
        "VVC-WF012-L107": { startNodeId: "_27651_11908_1200", camera: [31001, 83170, 59206], scene: [31603, 27982, 1803] },
        "VVC-WF013-L108": { startNodeId: "_43662_16489_1200", camera: [-18187, 67220, 53123], scene: [27767, 27274, 1803] },
        "VVC-WF014-L201": { startNodeId: "_15761_16812_1800", camera: [-12876, -29706, 50693], scene: [25823, 19826, 1803] },
        "VVC-WF015-L202": { startNodeId: "_16189_16484_1800", camera: [-12876, -29706, 50693], scene: [25823, 19826, 1803] },
        "VVC-WF016-L203": { startNodeId: "_21104_22505_1800", camera: [84195, 52121, 44770], scene: [38894, 24497, 1803] },
        "VVC-WF017-L204": { startNodeId: "_26697_32447_1800", camera: [73520, -18499, 45803], scene: [37667, 19448, 1803] },
        "VVC-WF018-L205": { startNodeId: "_27864_12899_1800", camera: [-28333, 52332, 41934], scene: [20826, 27148, 1803] },
        "VVC-WF019-L206": { startNodeId: "_34731_22936_1800", camera: [-24578, 38247, 35588], scene: [21401, 25171, 1803] },
        "VVC-WF020-L207": { startNodeId: "_44449_16810_1800", camera: [-18453, 68869, 42121], scene: [25672, 28964, 1803] },
        "VVC-WF021-L301": { startNodeId: "_26625_32064_2400", camera: [64065, -27657, 48834], scene: [35470, 18552, 1803] },
        "VVC-WF022-L302": { startNodeId: "_26866_32305_2400", camera: [64065, -27657, 48834], scene: [35470, 18552, 1803] }


		
    },
	
	defaultViewsByNodeId: {
        "_27174_23371_1200": { camera: [31040, 76296, 64082], scene: [31354, 26673, 1803] }, // default-View



        "_22573_33483_0": { camera: [-19794, -1543, 34342], scene: [26081, 23624, 1803]},     // VVC-WF001-B201
        "_38283_34759_0": { camera: [-18339, 61587, 30109], scene: [29023, 27491, 1803] },    // VVC-WF002-B202 - Intel-NUC
        "_15418_32104_600": {camera: [80262, 26167, 40399], scene: [36254, 26551, 1803] },    // VVC-WF003-B101
        "_25407_33647_600": {camera: [-4886, 63416, 33363], scene: [29438, 28027, 1803] },    // VVC-WF004-B102
        "_25150_33407_600": {camera: [-4886, 63416, 33363], scene: [29438, 28027, 1803] },    // VVC-WF005-B103
        "_15156_33211_1200": {camera: [-32832, 25550, 41572], scene: [22663, 25428, 1803] },  // VVC-WF006-L101
        "_16160_17789_1200": {camera: [-29158, 25699, 44770], scene: [23901, 25583, 1803] },  // VVC-WF007-L102
        "_16574_13706_1200": {camera: [30268, 80935, 60981], scene: [31198, 27660, 1803] },   // VVC-WF008-L103
        "_25643_36387_1200": {camera: [32301, -26214, 66227], scene: [32710, 20590, 1803] },  // VVC-WF009-L104
        "_27174_34786_1200": {camera: [-23738, 25999, 50708], scene: [23901, 25583, 1803] },  // VVC-WF010-L105
        "_27174_22675_1200": {camera: [31001, 83170, 59206], scene: [31603, 27982, 1803] },   // VVC-WF011-L106
        "_27651_11908_1200": {camera: [31001, 83170, 59206], scene: [31603, 27982, 1803] },   // VVC-WF012-L107
        "_43662_16489_1200": {camera: [-18187, 67220, 53123], scene: [27767, 27274, 1803] },  // VVC-WF013-L108
        "_15761_16812_1800": {camera: [-12876, -29706, 50693], scene: [25823, 19826, 1803] }, // VVC-WF014-L201
        "_16189_16484_1800": {camera: [-12876, -29706, 50693], scene: [25823, 19826, 1803] }, // VVC-WF015-L202
        "_21104_22505_1800": {camera: [84195, 52121, 44770], scene: [38894, 24497, 1803] },   // VVC-WF016-L203
        "_26697_32447_1800": {camera: [73520, -18499, 45803], scene: [37667, 19448, 1803] },  // VVC-WF017-L204
        "_27864_12899_1800": {camera: [-28333, 52332, 41934], scene: [20826, 27148, 1803] },  // VVC-WF018-L205
        "_34731_22936_1800": {camera: [-24578, 38247, 35588], scene: [21401, 25171, 1803] },  // VVC-WF019-L206
        "_44449_16810_1800": {camera: [-18453, 68869, 42121], scene: [25672, 28964, 1803] },  // VVC-WF020-L207
        "_26625_32064_2400": {camera: [64065, -27657, 48834], scene: [35470, 18552, 1803] },  // VVC-WF021-L301
        "_26866_32305_2400": {camera: [64065, -27657, 48834], scene: [35470, 18552, 1803] },  // VVC-WF022-L302
		"_27763_12465_1200": { camera: [32524, -11082, 32182], scene: [32763, 16269, 1803] }, // VVC-WF023-L109 - VVC-WF024-L110 - Landscape-Tablet
		
		
		"_14102_18580_0": { camera: [32956, 80615, 47741], scene: [32351, 34830, 1803]},     // VVC-FMC001-B201-Lobby-B
		"_44497_16598_0": { camera: [31365, -27214, 53217], scene: [32025, 17703, 1803]},    // VVC-FMC002-B202-Lobby-F
		"_46492_35464_0": { camera: [95522, 27528, 45966], scene: [43456, 27245, 1803]},     // VVC-FMC003-B203-Lobby-J
		"_23041_29391_0": { camera: [31672, -29002, 58022], scene: [32114, 21615, 1803]},    // VVC-FMC004-B204-Lobby-L
		"_17731_18875_600": { camera: [-24096, 24385, 38027], scene: [18097, 24552, 1803]},  // VVC-FMC005-B101-Lobby-B
		"_45769_16608_600": { camera: [32267, -24601, 57174], scene: [32668, 21212, 1803]},  // VVC-FMC006-B102-Lobby-F
		"_27627_30927_600": { camera: [-25346, 25511, 45053], scene: [18542, 25423, 1803]},  // VVC-FMC007-B103-Lobby-L
		"_13902_29159_600": { camera: [30357, -32847, 55063], scene: [30505, 20877, 1803]},  // VVC-FMC008-B104-Lobby-R
		"_46728_35731_1800": { camera: [29353, -23842, 60579], scene: [29081, 19964, 1803]}, // VVC-FMC009-L201-Lobby-J
		"_46899_39325_1800": { camera: [95826, 24104, 60994], scene: [36476, 24666, 1803]},  // VVC-FMC010-L202-Lobby-M
		"_27542_39915_1800": { camera: [88807, 24973, 69447], scene: [32160, 25848, 1803]},  // VVC-FMC011-L203-Lobby-N
		"_28363_39747_2400": { camera: [28975, -32819, 61140], scene: [28964, 20287, 1803]}  // VVC-FMC012-L301-Lobby-N

    },

    startNodeModel: {
        file: "app/assets/YOUAREHERE.obj",
        scale: [3, 3, 2],
        animate: false,
        animRotation: [0, 0, 5],
        animScale: [0.15, 7, 9],
        neutralRotation: true
    },

    uiKeyboard: true,
    uiKeyboardStayOpen: true,
    uiInteractionManager: true,
    noInteractionTimeoutSecs: 60, // secs
    newSessionTimeoutSecs: 25, // secs
    routeOpeningSoon: false,
    contextualSearch: false,
    searchSuggest: true,
    maxPOIsResults: 500,


    zoomInOutBtns: true,
    useFlyAnimation: false,
    orientPathPartDelay: 2000, // time in msecs
    pathAutoAnimate: false,
    pathAutoAnimateDelay: 0, // one second
    pathDirToPartAnimDelay: 1, // secs
    controlsRotate: true,
    controlsPan: true,
    controlsZoom: true,

    zoneTransitionDelay: 5000, // time in msecs
    mapAnimTime: 400, // time in msecs
    insideAreaDelta: 120, // pixels
	animPersonageSize: 300, // this is the sphere ray (in model units). used if no 3d model provided (default 1.5 * unitsPerMeter)
    multiFloorTransition: true,
	multiFloorTransitionInclineDelay: 2000, // time in msecs to tilt the zone (z1 and z2)
	multiFloorTransitionInclineAngle: 90, // Zone tilt angle (90 = fully horizontal)
    heightSpread: 25000,
	heightSpreadStep: 0.1, // zones spread animation stop (default 0.1). Smaller values more rendering.
    qrCodeSize: 110, // pixels
    maxDestinationsNb: 6,
	/* pathPartCollapseDistanceThreshold: 1000, // in model units */
    proxyBaseUrl: "https://mediafiles.abuzz.tech",

    surveyShowAll: true,
	clockDateFormat: { EN: "ddd, DD MMM", "ZH-CHS": "dddd, M月D日" },
    clockTimeFormat: { EN: "hh:mm A", "ZH-CHS": "A h:mm" },
    weatherCity: "Singapore, SG"
};

const customTopCategoriesCodes = [];
const customMainServicesCodes = ["toilets", "atm_", "taxi"];
const servicesWithResultsList = ["parking", "entrance", "atm_", "info", "evchargepods"];
const servicesWithResultsListSortField = null;

